
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

/////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float2 tex0			: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 position		: POSITION;
	float2 tex0			: TEXCOORD0;
};

////////////////////////////////////////////////////////////

VS_OUTPUT vs_brightPassShader_scenery( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	output.position = input.position;
	output.tex0 = input.tex0;

	return output;
}

//////////////////////////////////////////////////////////////

sampler sampler_colour_0 = sampler_state { Texture = (shader_texture_0); MipFilter = NONE;  };

float4 ps_brightPassShader_scenery( VS_OUTPUT input ) : COLOR
{
	return clamp((tex2D(sampler_colour_0, input.tex0) - float4(0.75,0.75,0.75,0)) * 5.0, 0, 0.5);
}

////////////////////////////////////////////////////////////

technique tech_brightPassShader_scenery_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_brightPassShader_scenery();	
		PixelShader = compile ps_2_0 ps_brightPassShader_scenery();
	}
}

technique tech_brightPassShader_scenery_11_00
{
	pass P0
	{
		VertexShader = NULL;	
		PixelShader = NULL;
	}
}